﻿<#
PowerShell egyszerű pc info
F.E.K. 2016.05.20
#>

function méretformáz ($lekérés)
{
If ($nagyságrend -eq " Gb") {$igazít=[math]::truncate($meghajtoinfo.$lekérés[$léptet]/1Gb)} Else {$igazít=[math]::truncate($meghajtoinfo.$lekérés[$léptet]/1Mb)}
$méret=[string]$igazít
set-variable méret -scope 1 -value $igazít
}

$host.ui.RawUI.WindowTitle="Egyszerű pc leltár (demo) -- F.E.K. --"
$ipok=1;$celeleje=0
Do {
 Write-Host ""
 Write-Host "Kérem a felmérendő pc eléréséhez szükséges adatokat"
 Write-Host "(gépnév, ipv4, vagy ipv4 tartomány xxx.xxx.xxx.xxx-xxx formátumban)"
 Write-Host ""
Do {
 $celpont=(Read-Host "Célpont? ")
}
Until ($celpont)
If ($celpont -match "\b\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\-\d{1,3}\b") 
	{$ipok=0
	$null=$celpont -match "(\d+)(?:-)(\d+)"
	$celeleje=[int]$matches[1]
	$celvege=[int]$matches[2]
	$null=$celpont -match "(\d+)(?:.)(\d+)(?:.)(\d+)"
	$elsoip=[int]$matches[1]
	$masodikip=[int]$matches[2]
	$harmadikip=[int]$matches[3]
	If (($elsoip -lt 0) -Or ($elsoip -gt 255) -Or ($masodikip -lt 0) -Or ($masodikip -gt 255) -Or ($harmadikip -lt 0) -Or ($harmadikip -gt 255) -Or ($celvege -gt 255) -Or ($celeleje -lt 0) -Or ($celeleje -gt $celvege)) {"Érvénytelen tartomány!"} Else {$ipok=1}
	$null=$celpont -match "\b\d{1,3}\.\d{1,3}\.\d{1,3}\b"
	$ipeleje=$matches[0]
 }
}
until ($ipok -eq $true )
Write-Host ""
Write-Host "Add meg a hitelesítéshez szükséges adatokat.."
$cred=Get-credential rendszergazda
If(!(Test-Path ".\jelentések")) {$null=new-item .\jelentések -Type directory} 
If(!(Test-Path ".\jelentések\összesített.csv")) {Write "PC leltár demo;;Created By F.E.K.;;;;;;;;;;;;"|out-file .\jelentések\összesített.csv -Encoding Default}
$ErrorActionPreference="SilentlyContinue"
Write-Host ""
do {
	If ($celeleje -ne 0) {$celpont=$ipeleje+"."+$celeleje}
	Write-Host -NoNewline $celpont": "
	$error.clear()
	$filenev=(Get-wmiobject Win32_computerSystem -ComputerName $celpont -Credential $cred).name
If ($error.count -eq 0) {
		Write-Host -NoNewline "felmérés alatt..." 
		 If (!(select-string -pattern $filenev -path .\jelentések\összesített.csv)) {		
		 $léptet=0
 			Write ";;;;;;;;Meghajtó;;;;Megosztások;;;Nyomtatók;;"|out-file -append .\jelentések\összesített.csv -Encoding Default
			Write "Gépnév;Domain;IPv4;Operációs rendszer;Bitmód;Gyártó;CPU;Memória;Betűjel;Elnevezés;Méret;Szabad;Név;Elérési út;Leírás;Név;Megosztás;Helye"|out-file -append .\jelentések\összesített.csv -Encoding Default
			$gepadatok=Get-wmiobject Win32_computerSystem -ComputerName $celpont -Credential $cred
			$oprendszeradatok=Get-wmiObject Win32_OperatingSystem -ComputerName $celpont -Credential $cred|Select-object Caption,OSArchitecture,Version,BuildNumber,InstallDate,PSComputerName,Organization,RegisteredUser
			$cpuadatok=Get-wmiobject Win32_processor -ComputerName $celpont -Credential $cred|select-object Name
			$megosztasadatok=Get-wmiobject Win32_Share -ComputerName $celpont -Credential $cred
			$meghajtoinfo=Get-wmiobject Win32_LogicalDisk -ComputerName $celpont -Credential $cred|Select-object DeviceID,VolumeName,Size,FreeSpace
			$nyomtatoinfo=Get-wmiobject Win32_Printer -ComputerName $celpont -Credential $cred|Select-object Name,ShareName,Location
			$ipcim=((Test-Connection $celpont -count 1|select Address,Ipv4Address).ipv4address).ipaddresstostring
			$infosor=$gepadatok.name+";"+$gepadatok.domain+";"+$ipcim+";"+$oprendszeradatok.caption+";"+$oprendszeradatok.OSArchitecture+";"+$gepadatok.model+";"+$cpuadatok.name+";"
			$ram=[math]::truncate($gepadatok.TotalPhysicalMemory/1Mb);$méret=[string]$ram;$infosor=$infosor+$méret+" Mb"+";"
			$infosor=$infosor+$meghajtoinfo.DeviceID[0]+";"+$meghajtoinfo.VolumeName[0]+";"
			$nagyságrend=" Gb";méretformáz "Size";$infosor=$infosor+$méret+$nagyságrend+";"
			méretformáz "FreeSpace";$infosor=$infosor+$méret+$nagyságrend+";"
			$infosor=$infosor+$megosztasadatok.name[0]+";"+$megosztasadatok.Path[0]+";"+$megosztasadatok.Description[0]+";"+$nyomtatoinfo.Name[0]+";"+$nyomtatoinfo.ShareName[0]+";"+$nyomtatoinfo.Location[0]+";"
			Write $infosor|out-file -append .\jelentések\összesített.csv -Encoding Default
		  	 If (($meghajtoinfo.Length) -gt ($megosztasadatok.Length)) {$lista=[int]($meghajtoinfo.Length)} Else {$lista=[int]($megosztasadatok.Length)}
			 If (($nyomtatoinfo.Length) -gt ($lista)) {$lista=[int]($nyomtatoinfo.Length)}
		$léptet=1
Do
 {
 $infosor=";;;;;;;;"+$meghajtoinfo.DeviceID[$léptet]+";"+$meghajtoinfo.VolumeName[$léptet]
  If (($meghajtoinfo.Size[$léptet]) -lt "") {$infosor=$infosor+";"} Else {
									  $nagyságrend=" Gb";méretformáz "Size"
									  $infosor=$infosor+$méret+$nagyságrend+";"								
									 }
  If (($meghajtoinfo.FreeSpace[$léptet]) -lt "") {$infosor=$infosor+";;"} Else {
									  	$nagyságrend=" Gb";méretformáz "FreeSpace"
									  	$infosor=$infosor+$méret+$nagyságrend+";"										
										}
 $infosor=$infosor+$megosztasadatok.name[$léptet]+";"+$megosztasadatok.Path[$léptet]+";"+$megosztasadatok.Description[$léptet]+";"+$nyomtatoinfo.Name[$léptet]+";"+$nyomtatoinfo.ShareName[$léptet]+";"+$nyomtatoinfo.Location[$léptet]+";"
 Write $infosor|out-file -append .\jelentések\összesített.csv -Encoding Default
 $léptet++
 }
Until ($léptet -eq $lista)
}
		Write "PC leltár demo, Created By F.E.K"|out-file -append .\jelentések\$filenev".txt" -Encoding Default
		Write "Munkaállomáson telepített szoftverek"|out-file -append .\jelentések\$filenev".txt" -Encoding Default
		Write "Felmérve: "$(Get-Date)|out-file -append .\jelentések\$filenev".txt" -Encoding Default
		Get-wmiobject Win32_Product -ComputerName $celpont -Credential $cred|select-object Description,IdentifyingNumber,InstallDate,InstallLocation,InstallSource,name,ProductID,Version|out-file -append .\jelentések\$filenev".txt" -Encoding Default
		Write-Host "OK"-foregroundcolor green
} Else {Write-Host "Sikertelen" -foregroundcolor red}
If ($celeleje -ne 0) {$celeleje=$celeleje+1} Else {$celvege=-1}
}
until ($celeleje -eq $celvege+1)
$null=New-PSDrive -name összegzés -PSProvider FileSystem -Root '.\jelentések'
$tablazat=((Resolve-Path összegzés:).ProviderPath)+"összesített"
$excel=New-Object -ComObject Excel.Application 
$excel.Visible=$true;$excel.displayalerts=$False
$excel.Workbooks.Open("$tablazat.csv").SaveAs("$tablazat.xlsx",51)
$excel.displayalerts=$True
$excel.Quit()
If (!(($celeleje -eq 0) -and ($filenev))) {ii .\jelentések\}
.\jelentések\összesített.xlsx 